<?php
require_once 'config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    // Add new columns to bank_transactions table
    $db->exec("
        ALTER TABLE bank_transactions 
        ADD COLUMN modified_by INTEGER REFERENCES users(id);
        
        ALTER TABLE bank_transactions 
        ADD COLUMN last_modified DATETIME;
    ");

    // Create cash_box_operations table
    $db->exec("
        CREATE TABLE IF NOT EXISTS cash_box_operations (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            operation_type TEXT NOT NULL,
            amount DECIMAL(10,2) NOT NULL,
            operation_date DATE NOT NULL,
            description TEXT,
            reference_number TEXT,
            created_by INTEGER,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            modified_by INTEGER,
            last_modified DATETIME,
            FOREIGN KEY(created_by) REFERENCES users(id),
            FOREIGN KEY(modified_by) REFERENCES users(id)
        )
    ");

    echo "تم تحديث قاعدة البيانات بنجاح!\n";

} catch (PDOException $e) {
    die("خطأ في تحديث قاعدة البيانات: " . $e->getMessage());
}
?>
