<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

// Fonction pour copier un répertoire et son contenu
function copyDirectory($source, $destination) {
    if (!is_dir($destination)) {
        mkdir($destination, 0755, true);
    }
    $dir = opendir($source);
    while (($file = readdir($dir)) !== false) {
        if ($file != '.' && $file != '..') {
            $srcFile = $source . '/' . $file;
            $destFile = $destination . '/' . $file;
            if (is_dir($srcFile)) {
                copyDirectory($srcFile, $destFile);
            } else {
                copy($srcFile, $destFile);
            }
        }
    }
    closedir($dir);
    return true;
}

// Connexion à la base de données SQLite
$db = new SQLite3('admin.db');

// Traitement du formulaire
$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    
    if (empty($name)) {
        $error = 'Le nom de l\'association est requis';
    } else {
        // Vérifier le nombre d'associations existantes
        $countStmt = $db->prepare('SELECT COUNT(*) as count FROM managers');
        $result = $countStmt->execute();
        $count = $result->fetchArray(SQLITE3_ASSOC)['count'];
        
        // Vérifier si la limite de 60 associations est atteinte
        if ($count >= 12) {
            $error = 'Impossible de créer une nouvelle association. La limite maximale est atteinte.';
        } else {
            // Générer un nom de dossier unique
            $folderName = uniqid();
            $folderPath = __DIR__ . '/' . $folderName;
            
            // Copier le dossier de gestion
            $sourceDir = __DIR__ . '/gestion';
            if (is_dir($sourceDir) && copyDirectory($sourceDir, $folderPath)) {
                // Enregistrer l'association dans la base de données
                $stmt = $db->prepare('INSERT INTO managers (name, folder_name, created_at) VALUES (:name, :folder_name, :created_at)');
                $stmt->bindValue(':name', $name, SQLITE3_TEXT);
                $stmt->bindValue(':folder_name', $folderName, SQLITE3_TEXT);
                $stmt->bindValue(':created_at', date('d/m/Y \à H:i'), SQLITE3_TEXT);
                
                if ($stmt->execute()) {
                    $success = 'L\'association a été ajoutée avec succès';
                } else {
                    $error = 'Erreur lors de l\'ajout de l\'association dans la base de données';
                }
            } else {
                $error = 'Erreur lors de la création du dossier de l\'association';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ajouter une Association - Portail de Gestion</title>
    <link rel="stylesheet" href="styles.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <header class="main-header">
        <h1><i class="fas fa-users-cog"></i> Portail de Gestion des Associations</h1>
        <nav>
            <a href="index.php" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Retour</a>
            <a href="change_password.php" class="btn btn-info"><i class="fas fa-key"></i> Changer Mot de Passe</a>
            <a href="logout.php" class="btn btn-logout"><i class="fas fa-sign-out-alt"></i> Déconnexion</a>
        </nav>
    </header>

    <div class="container">
        <div class="card">
            <div class="card-header">
                <h2><i class="fas fa-user-plus"></i> Ajouter une Association</h2>
            </div>
            <div class="card-body">
                <?php if (!empty($success)): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i> <?php echo $success; ?>
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($error)): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
                    </div>
                <?php endif; ?>
                
                <form action="add_manager.php" method="POST">
                    <div class="form-group">
                        <label for="name"><i class="fas fa-user"></i> Nom de l'Association</label>
                        <input type="text" id="name" name="name" required autofocus>
                    </div>
                    
                    <div class="form-group">
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-plus-circle"></i> Ajouter l'Association
                        </button>
                        <a href="index.php" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Annuler
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
