<?php
session_start();

class Auth {
    private $db;
    private $pdo;

    public function __construct($database) {
        $this->db = $database;
        $this->pdo = $database->getConnection();
    }

    public function login($username, $password) {
        $stmt = $this->pdo->prepare("SELECT * FROM users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['role'] = $user['role'];
            return true;
        }
        return false;
    }

    public function logout() {
        session_destroy();
    }

    public function isLoggedIn() {
        return isset($_SESSION['user_id']);
    }

    public function getCurrentUser() {
        if ($this->isLoggedIn()) {
            $stmt = $this->pdo->prepare("SELECT * FROM users WHERE id = ?");
            $stmt->execute([$_SESSION['user_id']]);
            return $stmt->fetch();
        }
        return null;
    }

    public function requireLogin() {
        if (!$this->isLoggedIn()) {
            header('Location: index.php?page=login');
            exit;
        }
    }

    public function hasPermission($role) {
        if (!$this->isLoggedIn()) {
            return false;
        }
        
        // Le président a accès à toutes les fonctionnalités
        if ($_SESSION['role'] === 'president') {
            return true;
        }

        // Le trésorier a accès aux fonctionnalités financières
        if ($role === 'treasurer') {
            return in_array($_SESSION['role'], ['admin', 'treasurer', 'president']);
        }
        
        // L'administrateur a accès à tout sauf les fonctionnalités réservées au président
        if ($_SESSION['role'] === 'admin') {
            return true;
        }

        // Les autres rôles n'ont accès qu'aux fonctionnalités de base
        return in_array($role, ['member', 'basic']);
    }

    public function isAdmin() {
        return isset($_SESSION['role']) && $_SESSION['role'] === 'admin';
    }

    public function requireAdmin() {
        if (!$this->isLoggedIn() || !$this->isAdmin()) {
            header('Location: index.php?page=login');
            exit;
        }
    }
}
?>
