<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../config/database.php';

$database = new Database();
$db = $database->getConnection();
$auth = new Auth($database);

// Vérifier si l'utilisateur est connecté
if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit();
}

$error = '';
$success = '';

// Traiter le changement de mot de passe
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];
    
    // Vérifier que les champs ne sont pas vides
    if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
        $error = 'جميع الحقول مطلوبة';
    }
    // Vérifier que le nouveau mot de passe correspond à la confirmation
    elseif ($new_password !== $confirm_password) {
        $error = 'كلمة المرور الجديدة لا تتطابق مع تأكيد كلمة المرور';
    }
    // Vérifier que le nouveau mot de passe est différent de l'ancien
    elseif ($current_password === $new_password) {
        $error = 'كلمة المرور الجديدة يجب أن تكون مختلفة عن كلمة المرور الحالية';
    }
    else {
        // Vérifier le mot de passe actuel
        $stmt = $db->prepare("SELECT password FROM users WHERE id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!password_verify($current_password, $user['password'])) {
            $error = 'كلمة المرور الحالية غير صحيحة';
        }
        else {
            // Mettre à jour le mot de passe
            $password_hash = password_hash($new_password, PASSWORD_DEFAULT);
            $stmt = $db->prepare("UPDATE users SET password = ? WHERE id = ?");
            
            if ($stmt->execute([$password_hash, $_SESSION['user_id']])) {
                $success = 'تم تغيير كلمة المرور بنجاح';
            } else {
                $error = 'حدث خطأ أثناء تغيير كلمة المرور';
            }
        }
    }
}

// Rediriger vers la page précédente avec le message approprié
$redirect_url = 'index.php';
if (isset($_SERVER['HTTP_REFERER'])) {
    $redirect_url = $_SERVER['HTTP_REFERER'];
}

if ($error) {
    header('Location: ' . $redirect_url . '&error=' . urlencode($error));
} elseif ($success) {
    header('Location: ' . $redirect_url . '&success=' . urlencode($success));
}
exit();
?>
