<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../config/database.php';

$database = new Database();
$db = $database->getConnection();
$auth = new Auth($database);

// Get financial summary
$stmt = $db->query("
    SELECT 
        SUM(CASE WHEN type = 'income' THEN amount ELSE 0 END) as total_income,
        SUM(CASE WHEN type = 'expense' THEN amount ELSE 0 END) as total_expense
    FROM financial_transactions
    WHERE transaction_date >= date('now', 'start of month')
");
$financial_summary = $stmt->fetch(PDO::FETCH_ASSOC);
$balance = $financial_summary['total_income'] - $financial_summary['total_expense'];

// Get recent transactions
$stmt = $db->query("
    SELECT ft.*, 
           CASE 
               WHEN ft.type = 'income' THEN ic.name 
               ELSE ec.name 
           END as category_name
    FROM financial_transactions ft
    LEFT JOIN income_categories ic ON ft.type = 'income' AND ft.category_id = ic.id
    LEFT JOIN expense_categories ec ON ft.type = 'expense' AND ft.category_id = ec.id
    ORDER BY ft.transaction_date DESC
    LIMIT 5
");
$recent_transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get upcoming activities
$stmt = $db->query("
    SELECT *
    FROM activities
    WHERE date >= date('now')
    ORDER BY date ASC
    LIMIT 5
");
$upcoming_activities = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get members count
$stmt = $db->query("
    SELECT COUNT(*) as total_members
    FROM members
    WHERE status = 'active'
");
$members_count = $stmt->fetch(PDO::FETCH_ASSOC);

// Get assets requiring maintenance
$stmt = $db->query("
    SELECT COUNT(*) as maintenance_count
    FROM assets
    WHERE status = 'maintenance'
");
$assets_maintenance = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<div class="container-fluid">
    <!-- Welcome Message -->
    <div class="row mb-4">
        <div class="col">
            <h2>لوحة التحكم</h2>
            <p class="text-muted">مرحباً بك في نظام إدارة الجمعية</p>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h5 class="card-title">الرصيد الحالي</h5>
                    <h3 class="card-text"><?php echo number_format($balance, 2); ?> درهم</h3>
                    <small>للشهر الحالي</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5 class="card-title">عدد الأعضاء</h5>
                    <h3 class="card-text"><?php echo $members_count['total_members']; ?></h3>
                    <small>الأعضاء النشطين</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <h5 class="card-title">الأنشطة القادمة</h5>
                    <h3 class="card-text"><?php echo count($upcoming_activities); ?></h3>
                    <small>في الأيام القادمة</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <h5 class="card-title">ممتلكات تحتاج صيانة</h5>
                    <h3 class="card-text"><?php echo $assets_maintenance['maintenance_count']; ?></h3>
                    <small>تحتاج إلى المتابعة</small>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Recent Transactions -->
        <div class="col-md-6 mb-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">آخر المعاملات المالية</h5>
                    <a href="index.php?page=finances" class="btn btn-sm btn-primary">عرض الكل</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>التاريخ</th>
                                    <th>النوع</th>
                                    <th>التصنيف</th>
                                    <th>المبلغ</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_transactions as $transaction): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($transaction['transaction_date']); ?></td>
                                    <td>
                                        <span class="badge <?php echo $transaction['type'] === 'income' ? 'bg-success' : 'bg-danger'; ?>">
                                            <?php echo $transaction['type'] === 'income' ? 'مدخول' : 'مصروف'; ?>
                                        </span>
                                    </td>
                                    <td><?php echo htmlspecialchars($transaction['category_name']); ?></td>
                                    <td><?php echo number_format($transaction['amount'], 2); ?> درهم</td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Upcoming Activities -->
        <div class="col-md-6 mb-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">الأنشطة القادمة</h5>
                    <a href="index.php?page=activities" class="btn btn-sm btn-primary">عرض الكل</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>التاريخ</th>
                                    <th>النشاط</th>
                                    <th>المكان</th>
                                    <th>الوقت</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($upcoming_activities as $activity): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($activity['date']); ?></td>
                                    <td><?php echo htmlspecialchars($activity['name']); ?></td>
                                    <td><?php echo htmlspecialchars($activity['location']); ?></td>
                                    <td><?php echo htmlspecialchars($activity['time']); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                   
                </div>
            
            </div>
        </div>
    </div>
</div>
